using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.ExceptionManagement;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///	Data access component implementing data persistence logic for a shipment. 
		///	Retrieves/saves shipment information from/to database
		///</summary>

		#endregion

    public class Shipment
    {

		#region Select Methods

        ///<Developers>
        ///	<Developer>Mike      </Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>1/16/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1202"> 
        ///		<ExpectedInput>Valid invoice number, local supplier GUID</ExpectedInput>
        ///		<ExpectedOutput>Data table of incoming shipment information for an invoice within a division</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2225"> 
        ///		<ExpectedInput>Invalid Parameters</ExpectedInput>
        ///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        ///  Gets the incoming shipment information for an invoice within a division.
        /// </summary>
        /// <param name="invoiceNumber">Invoice number</param>
        /// <param name="localSupplierGuid">Local Supplier GUID</param>
        /// <returns>DataTable containing incoming shipment information </returns>
        public static DataTable GetIncomingShipment(string invoiceNumber, Guid localSupplierGuid) 
        {
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetIncomingShipment.invoicenumber, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetIncomingShipment.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetIncomingShipment.processingdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetIncomingShipment.divisioncode, System.Data.SqlDbType.Char,5)
			};

			prms[0].Value = (invoiceNumber == string.Empty) ? null : invoiceNumber;
			
			if (localSupplierGuid == System.Guid.Empty)
                prms[1].Value = null;
			else
				prms[1].Value = localSupplierGuid;

			prms[2].Value = null;
			prms[3].Value = Common.LogonUser.LogonUserDivisionCode.Trim();
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetIncomingShipment.StoredProcName, prms);
			ds.Tables[0].Columns[TABLE.Shipment.ShipmentDate].ReadOnly = false;

			return ds.Tables[0];
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/4/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1403"> 
		///		<ExpectedInput>Valid invoice number, local supplier GUID, ProcessingDate</ExpectedInput>
		///		<ExpectedOutput>Data table of incoming shipment information for an invoice on the processing date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1404"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetIncomingShipment
		/// </summary>
		/// <param name="invoiceNumber">invoiceNumber</param>
		/// <param name="localSupplierGuid">localSupplierGUID</param>
		/// <param name="processingDate">processingDate</param>
		/// <returns>Data table of Incoming Shipments</returns>
		public static DataTable GetIncomingShipment(string invoiceNumber, Guid localSupplierGuid, System.DateTime processingDate) 
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetIncomingShipment.invoicenumber, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetIncomingShipment.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetIncomingShipment.processingdate, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetIncomingShipment.divisioncode, System.Data.SqlDbType.Char,5)
			};
				
			prms[0].Value = invoiceNumber;
			prms[1].Value = localSupplierGuid;
			prms[2].Value = processingDate;
			prms[3].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetIncomingShipment.StoredProcName, prms);
			ds.Tables[0].Columns[TABLE.Shipment.ShipmentDate].ReadOnly = false;

			return ds.Tables[0];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/23/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8065"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8066"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetOutgoingBloodUnitShipment
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataTable GetOutgoingBloodUnitShipment(Guid bloodUnitGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetOutgoingBloodUnitShipment.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetOutgoingBloodUnitShipment.divisioncode, System.Data.SqlDbType.Char)
			};
				
			prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetOutgoingBloodUnitShipment.StoredProcName, prms);

			return ds.Tables[0];
		}
		///<Developers>
		///	<Developer>Department of Veterans Affairs</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/15/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9241"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9242"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetOriginalBloodUnitShipper, CR 3193
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataTable GetOriginalBloodUnitShipper(Guid bloodUnitGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetBloodUnitOriginalShipper.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodUnitOriginalShipper.divisioncode, System.Data.SqlDbType.Char)
			};
				
			prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitOriginalShipper.StoredProcName, prms);

			return ds.Tables[0];
		}
		

        ///<Developers>
        ///	<Developer>Carl Jensen</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>1/16/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1211"> 
        ///		<ExpectedInput>Valid division</ExpectedInput>
        ///		<ExpectedOutput>Data table of the shipments that were received within the last 5 days.</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2240"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        ///  Gets the shipments that were received within the last 5 days 
        ///  in a given division.
        /// </summary>
        /// <returns>DataTable</returns>
        public static DataTable GetShipmentsWithAvailableUnitsPastFiveDays()
        {
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetShipmentsWithAvailableUnitsFromPastFiveDays.divisioncode, System.Data.SqlDbType.VarChar) 
			};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetShipmentsWithAvailableUnitsFromPastFiveDays.StoredProcName, prms);
			
			ds.Tables[0].Columns[TABLE.Shipment.ShipmentDate].ReadOnly = false;
            return ds.Tables[0];
        }	

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/4/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1405"> 
		///		<ExpectedInput>ShipmentGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of Shipment Information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1406"> 
		///		<ExpectedInput>Invlaid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Retrieves a DataTable with shipment 
		///	information based on shipment GUID. 		
		///	</summary>
		///	<param name="shipmentGuid">Shipment GUID</param>
		///	<returns>DataTable with shipment information</returns>
		public static DataTable GetShipment(System.Guid shipmentGuid)
        {
			SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetShipment.shipmentguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetShipment.divisioncode, System.Data.SqlDbType.Char,5)
				};
					
			prms[0].Value = shipmentGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
            DataSet ds = StoredProcedure.GetData(STOREDPROC.GetShipment.StoredProcName, prms);

			ds.Tables[0].Columns[TABLE.Shipment.ShipmentDate].ReadOnly = false;
			ds.Tables[0].Columns[TABLE.Shipment.LastUpdateDate].ReadOnly = false;
		
			return ds.Tables[0];  
        }


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/4/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1407"> 
		///		<ExpectedInput>BloodUnit Guid</ExpectedInput>
		///		<ExpectedOutput>DataTable of Shipment Information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1408"> 
		///		<ExpectedInput>Invlaid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets shipment information based on a shipment guid and a blood unit guid.
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataTable GetShipmentByUnit(System.Guid bloodUnitGuid)
		{
			SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetShipmentByUnit.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetShipmentByUnit.divisioncode, System.Data.SqlDbType.Char,5)
				};
					
			prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetShipmentByUnit.StoredProcName, prms);

			ds.Tables[0].Columns[TABLE.Shipment.ShipmentDate].ReadOnly = false;
			ds.Tables[0].Columns[TABLE.Shipment.LastUpdateDate].ReadOnly = false;
			return ds.Tables[0];  
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5447"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing incoming shipment data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5448"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the list of incoming shipments for a date range
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetIncomingShipments(DateTime startDate, DateTime endDate) 
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetIncomingShipmentsList.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetIncomingShipmentsList.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetIncomingShipmentsList.divisioncode, System.Data.SqlDbType.Char,5)
			};
				
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetIncomingShipmentsList.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5449"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing OutgoingShipments data</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="5450"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the list of outgoing shipments for a date range
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetOutgoingShipments(DateTime startDate, DateTime endDate) 
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetOutgoingShipmentsList.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetOutgoingShipmentsList.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetOutgoingShipmentsList.divisioncode, System.Data.SqlDbType.Char,5)
			};
				
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetOutgoingShipmentsList.StoredProcName, prms);
			return ds.Tables[0];
		}

		#endregion
		#region Update Methods


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/4/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1411"> 
		///		<ExpectedInput>ShipmentGuid, DataSet, UpdateFunction</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1412"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Saves an incoming shipment and blood unit tests information within a transaction.
		/// </summary>
		/// <param name="shipmentGuid"></param>
		/// <param name="dsSave"></param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <param name="reenteredUnit">Indicates if the user is re-entering a previosly dispositioned unit</param>
		public static void SaveIncomingShipment(Guid shipmentGuid, bool reenteredUnit, DataSet dsSave, Common.UpdateFunction lastUpdateFunctionId)
		{
			System.Collections.ArrayList sprocArray = new System.Collections.ArrayList();
			System.Collections.ArrayList dtArray = new System.Collections.ArrayList();

			//Step 1 - Find out if this will be an insert/update
			System.Data.DataTable dt = DAL.Shipment.GetShipment(shipmentGuid);
			int results = dt.Rows.Count;

			//Loop through the dataset to include all the tables in transaction
			foreach (DataTable dtSave in dsSave.Tables)
			{
				if(dtSave.TableName == TABLE.Shipment.TableName && dt.Rows.Count == 0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					sprocArray.Add(STOREDPROC.InsertShipment.StoredProcName);
				}

				if (dtSave.TableName == TABLE.BloodUnit.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					if(!reenteredUnit)
						sprocArray.Add(STOREDPROC.InsertBloodUnit.StoredProcName);
					else
						sprocArray.Add(STOREDPROC.UpdateBloodUnit.StoredProcName);
				}
				if (dtSave.TableName == TABLE.BloodUnitFinance.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					if(!reenteredUnit)
						sprocArray.Add(STOREDPROC.InsertBloodUnitFinance.StoredProcName);
					else
						sprocArray.Add(STOREDPROC.UpdateBloodUnitFinance.StoredProcName);
				}
				if (dtSave.TableName == TABLE.BloodUnitMedia.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					if(!reenteredUnit)
						sprocArray.Add(STOREDPROC.InsertBloodUnitMedia.StoredProcName);
					else
						sprocArray.Add(STOREDPROC.UpdateBloodUnitMedia.StoredProcName);
				}
				if (dtSave.TableName == TABLE.BloodUnitStatus.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					if(!reenteredUnit)
						sprocArray.Add(STOREDPROC.InsertBloodUnitStatus.StoredProcName);
					else
						sprocArray.Add(STOREDPROC.UpdateBloodUnitStatus.StoredProcName);
				}
				if(!reenteredUnit)
				{
					if (dtSave.TableName == TABLE.BloodUnitAntigen.TableName)
					{
						System.Data.DataTable dtAntigen = dtSave.Copy();
						foreach(System.Data.DataRow dtRow in dtSave.Rows)
						{						
							if(DAL.BloodUnitAntigen.GetBloodUnitAntigenByGuidAndID((System.Guid) dtRow[TABLE.BloodUnitAntigen.BloodUnitGuid], (System.Int32) dtRow[TABLE.BloodUnitAntigen.AntigenTypeId]).Rows.Count >0)
							{
								System.Data.DataRow[] dtRows =	dtAntigen.Select("BloodUnitGuid = '" + dtRow[TABLE.BloodUnitAntigen.BloodUnitGuid].ToString() + "' AND AntigenTypeID = " + dtRow[TABLE.BloodUnitAntigen.AntigenTypeId].ToString() );
								if(dtRows.Length >0)
								{
									System.Data.DataRow dr = dtRows[0];

									dtAntigen.Rows.Remove(dr);
								}
							}
						}
						dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtAntigen, lastUpdateFunctionId));
						sprocArray.Add(STOREDPROC.InsertBloodUnitAntigen.StoredProcName);
					}
				}

				if(dtSave.TableName == TABLE.BloodUnitShipment.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					sprocArray.Add(STOREDPROC.InsertBloodUnitShipment.StoredProcName);
				}
				if(!reenteredUnit)
				{
					if (dtSave.TableName == TABLE.BloodUnitTest.TableName)
					{
						dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
						sprocArray.Add(STOREDPROC.InsertBloodUnitTest.StoredProcName);
					}
				}
				if(dtSave.TableName == TABLE.WorkloadEvent.TableName)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtSave, lastUpdateFunctionId));
					sprocArray.Add(STOREDPROC.InsertWorkloadEvents.StoredProcName);
				}
				if(dtSave.TableName == TABLE.ExceptionExpiredUnitReceived.TableName)
				{
					dtArray.Add(dtSave);
					sprocArray.Add(STOREDPROC.InsertExceptionExpiredUnitReceived.StoredProcName);
				}
			}
			
			int returnValue = new Common.StoredProcedure().TransactionalGetValue(sprocArray, dtArray);
		}

	}
		#endregion
}



